/*
 * Copyright (c) 2013 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "Socket.h"
#include "TCPSocketConnection.h"

extern "C" {
#include "connector_api.h"
#include "ecc_platform.h"
}
#if defined CONNECTOR_TRANSPORT_TCP


TCPSocketConnection socket;

static connector_callback_status_t app_network_tcp_close(connector_network_close_t * const data)
{
    socket.close();

    return connector_callback_continue;
}


/*
 * This routine reads a specified number of bytes from Device Cloud.  This
 * function must not block. If it encounters EAGAIN  error, return
 * connector_callback_busy and Cloud Connector will ignore the read_data and read_length
 * and continue calling this function.
 */
static connector_callback_status_t app_network_tcp_receive(connector_network_receive_t * const data)
{
    int bytes_read;
    connector_callback_status_t status = connector_callback_continue;
    
    bytes_read = socket.receive((char *)data->buffer, data->bytes_available);
    
    if (bytes_read <= 0)
    {
        data->bytes_used = 0;
        status = connector_callback_busy;
    }
    else
    {
        data->bytes_used = bytes_read;
        status = connector_callback_continue;
    }
    return status;
}

/*
 * Sends data to Device Cloud, this routine must not block.  If it encounters
 * EAGAIN  error, return connector_callback_busy and Cloud Connector will ignore the
 * sent_length and continue calling this function.
 */
static connector_callback_status_t app_network_tcp_send(connector_network_send_t * const data)
{
    data->bytes_used = socket.send((char *)data->buffer, data->bytes_available);

    return data->bytes_used <= 0 ? connector_callback_busy : connector_callback_continue;
}


static connector_callback_status_t app_network_tcp_open(connector_network_open_t * const data)
{
    socket.connect("login.etherios.com", CONNECTOR_PORT);
    socket.set_blocking(false, 500);
    return connector_callback_continue;
}


/*
 *  Callback routine to handle all networking related calls.
 */
connector_callback_status_t app_network_tcp_handler(connector_request_id_network_t const request_id,
                                                    void * const data)
{
    connector_callback_status_t status;

    switch (request_id)
    {
    case connector_request_id_network_open:
        status = app_network_tcp_open((connector_network_open_t *)data);
        break;

    case connector_request_id_network_send:
        status = app_network_tcp_send((connector_network_send_t *)data);
        break;

    case connector_request_id_network_receive:
        status = app_network_tcp_receive((connector_network_receive_t *)data);
        break;

    case connector_request_id_network_close:
        status = app_network_tcp_close((connector_network_close_t *)data);
        break;

    default:
        APP_DEBUG("app_network_tcp_handler: unrecognized callback request_id [%d]\n", request_id);
        status = connector_callback_unrecognized;
        break;

    }

    return status;
}
#endif


