/*
 * Copyright (c) 2013 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "EthernetInterface.h"

extern "C" {

#include "connector_api.h"
#include "ecc_platform.h"

}

static void connector_run_thread(void const * arg)
{

    APP_DEBUG("connector_run thread starts\n");

    for (;;)
    {
        connector_status_t const status = connector_run((void *)arg);

        APP_DEBUG("connector_run returns %d\n", status);

        if (status != connector_open_error) break;
    }


    APP_DEBUG("connector_run thread exits\n");

}

static void application_run_thread(void const * arg)
{
    int status;

    APP_DEBUG("application_run thread starts\n");

    status = application_run((void *)arg);

    APP_DEBUG("application_run thread exits %d\n", status);

}

int main (void)
{
    EthernetInterface interface;

    connector_handle_t connector_handle;
    
    set_time(0);
    printf("Starting Ethernet interface\n");
    
    interface.init();
    interface.connect();
    printf("IP Address is %s\n\r", interface.getIPAddress());
    
    APP_DEBUG("Start Cloud Connector for Embedded\n");
    connector_handle = connector_init(app_connector_callback);

    if (connector_handle == NULL)
    {
        APP_DEBUG("Unable to initialize the connector\n");
        ASSERT(0);
    }
    
    {
        Thread connector_thread(connector_run_thread, connector_handle, osPriorityNormal, DEFAULT_STACK_SIZE);
        Thread application_thread(application_run_thread, connector_handle, osPriorityNormal, DEFAULT_STACK_SIZE);
        DigitalOut myled(LED1);
        for(;;)
        {
            myled = !myled.read();
            wait(0.5);
        }
    }

    return 0;
}

