#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
#include <sstream>
#define READALL_OFF 1
#define SETTIME_OFF 2
#define SETT_OFF    4
#define READ_OFF    7
#define ALL_OFF     9



DigitalOut myled(LED1);
I2C i2c2(I2C_SDA, I2C_SCL);
Serial pc(USBTX, USBRX);
float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100;
char buffer_str=0;
uint32_t seconds = 0, minutes=0, hours=0;
Ticker t;
volatile static unsigned short sample16 = 0;
void doSample1Hz();
int count = 0;
char *buf;
size_t sz;
int oldest;

typedef struct {
    float temp;
    float press;
    float humid;
} measurement;

measurement buffer[120];

LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);

void function1();


Thread t1;
Thread tSample;

osThreadId idMain;
osThreadId id1;
osThreadId id2;
osThreadId id3;
osThreadId id4;

Ticker ticker;

void function1()
{
    //begin function
    while (true) {//begin while true
        char strbuffer [128];
        scanf("%127s", strbuffer);
        string buffer_str(strbuffer);
        char date [32];
        strftime(date, 32, "%Y/%m/%d %a", localtime(&seconds));
        char time [32];
        strftime(time, 32, "%H:%M:%S %p", localtime(&seconds));

        if(buffer_str=="READALL") {//begin if buffer readall

            // displays all the variables of time, date, temperature, humidity and all the barometric readings to the serial
            for (int i = 0; i <120; i++) {
                //printf("%s, %s, %4.2fC , %3.1f%%,  %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, buffer[i].humid, buffer[i].press, buffer[i].temp, barometer.temperature());
                //measurement test=buffer[i];
                printf("%f %f %f \n\r",buffer[i].humid, buffer[i].press, buffer[i].temp);
            }
            myled = 1; // LED is ON
            Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds!
            myled = 0; // LED is OFF

        }//end if buffer readall




        if(buffer_str=="SETTIME") {// begin if buffer settime
            set_time(1508268288);   //sets time in UTC
            printf("time and date updated to %s %s\n\r", time, date); //prints date and time
            myled = 1;  //led on
            Thread::wait(200); // wait 200ms
            myled = 0; //led off

        }//end if buffer settime



        if(buffer_str=="SETT") { // begin if buffer sett
            for (count = 0; count < 5; count++) {
                float temp = barometer.temperature();
                float pressure = barometer.pressure();

                sz = snprintf(NULL, 0,"%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, pressure, temp);
                buf = (char *)malloc(sz + 1);
                snprintf(buf, sz + 1, "%s, %s, %4.2fC , %3.1f%%, %6.1f, %4.1f\n\r", time, date, tempCelsius, humi, pressure, temp);
                printf("%s\n\r",buf);
                free(buf);
                printf("written to memory\n\r");
                myled = 1;
                Thread::wait(200);
                myled = 0;

            } //end if buffer sett

        }




        if(buffer_str=="READ") { //begin if buffer read
            printf("%s\n\r", buf);
            myled = 1;
            Thread::wait(200);
            myled = 0;

        }//end if buffer read

    }//end while true
}//end function

void getSampleThread()
{
    while (true) {
        Thread::signal_wait(99);
        //Get samples
        measurement m;
        
        float pressure = barometer.pressure();
        m.press = pressure;

        float temp;
        float humidityval;
        humidity.ReadTempHumi(&temp, &humidityval); // reads temperature and humity levels
        m.humid = humidityval;
        m.temp = temp;

        buffer[oldest] = m;

        //update oldest
        oldest++;
        //wrap back to zero if at the end
        if (oldest>120) {
            oldest = 0;
        }
    }
}

void getSample()
{
    tSample.signal_set(99);
}

int main()
{
    time_t seconds = time(NULL);
    pc.baud(9600); //sets baud rate to 9600
    ticker.attach(getSample, 15);
    tSample.start(getSampleThread);
    idMain = osThreadGetId();
    t1.start(function1);
    id1 = t1.gettid();
    humidity.init();
    humidity.calib();
    printf("Type SETTIME to set time and date [enter] \n\r");
    printf("Type SETT to start sampling [ENTER]\n\r");
    printf("Type DELETEALL to delete sensor data [enter]\n\r");
    printf("Type READALL [enter]\n\r");
    printf("Type READ to read sensor data in memory [ENTER]\n\r");


    while(1) {
        char buffer [128];
        scanf("%127s", buffer);
        string buffer_str(buffer);
        osSignalWait(ALL_OFF,osWaitForever);

    }
}

