#include "mbed.h"
#include "rtos.h"

#include "Logger.h"

#include "NRFDevKit.h"
#include "WeatherStation.h"
#include "GAPPeripheral.h"
#include "ble/BLE.h"


int main () {
    
    // Instantiate of various data members 
    Logger logger(true);

    NRFDevKit devKit(logger);

    // Instantiate of the station
    WeatherStation weather(devKit, logger, BLE::Instance());
    
    logger.log("Code written by spada gaetan\r\n");
        
    // Station's launch
    weather.start();
    
}