#pragma once

#include "Logger.h"
#include "IDevKit.h"
#include "LPS25HBDevice.h"
#include "HDC1000Device.h"
#include "MeasurementHistory.h"
#include "ble/BLE.h"
#include "GAPPeripheral.h"
#include "BatteryService.h"
#include "EnvironmentalService.h"
#include <ctime>


class WeatherStation : public GAPPeripheral {
public:
  // constructor
  WeatherStation(IDevKit& iDevKit, Logger& logger, BLE& ble);
  
  // called for starting the weather station
  // it will start getting measurements and advertise with data measurements
  void start();
  
  // called by timer
  void performMeasurements(void);
  
  //  Called at the end of performMeasurements(void): encode and send values to the GAP Peripheral
  void setupAdvertisementPayload(double pressure, double temp, double humidity);
  
  virtual void onInitComplete(BLE::InitializationCompleteCallbackContext *event);
    
private:
  // data members
    
  // event queue for handling all events (including timers)
  events::EventQueue m_eventQueue;
    
  // measurement interval
  static const int m_measurementInterval;
  
  // blink interval
  static const int m_blinkInterval;
  
  //Station name
  static const string m_stationName;
  
  // reference to dev kit
  IDevKit& m_iDevKit;
  
  // reference to logger
  Logger& m_logger;
  
  // reference to devices
  LPS25HBDevice m_lps25hb;
  
  HDC1000Device m_hdc1000;
  
  //  reference to values' history storage
  MeasurementHistory m_history;
  
  //  reference to advertising payload
  ServiceDataPayload dataPayload[1];
  
  //  services
  BatteryService m_batteryService;
  
  EnvironmentalService m_environmentalService;

};
