#pragma once

#include <mbed.h>

#include "Logger.h"
#include "IDevKit.h"

class NRFDevKit : public IDevKit {
public:
  // constructor
  NRFDevKit(Logger& logger);
 
/*  // method called for blinking a led
  void blink1(void);
  
  // method called for getting battery level
  uint8_t getBatteryLevel(void);
  
  // for configuring the I2C bus
  PinName getSCL(void);
  PinName getSDA(void);
  PinName getDataRdy(void);*/
  
  virtual void toggleLed1(void);
  
  // method called for getting battery level
  virtual uint8_t getBatteryLevel(void);
  
  // for configuring the I2C bus
  virtual PinName getSCL(void);
  virtual PinName getSDA(void);
  virtual PinName getDataRdy(void);
  
private:
  // data members
  // array of leds
  DigitalOut m_led1;
  
  // logger instance
  Logger& m_logger;
};
