#pragma once

#include <stdint.h>
#include "Logger.h"

class MeasurementHistory {
public:
  // constructor
  MeasurementHistory(Logger logger);
  
  //    Add some new values to the history
  void addMeasurement(uint32_t pressure, int16_t temp, uint16_t humidity, uint32_t time);
  
  //return the trend of the pressure (not a "value" but the enum)
  int getPressureTrend( uint32_t newPressure);
    
private:

  struct Data {
    uint32_t pressure;
    int16_t temp;
    uint16_t humidity;
    uint32_t time;
    //  Size: 96 bits, 12 Bytes
  };
  
  // Enum for pressure trend
  enum pressureTrendStates {
    UNKNOWN                 = 0,
    FALLING_CONTINUOUSLY    = 1,
    RISING_CONTINUOUSLY     = 2,
    FALLING_STEADY          = 3,
    RISING_STEADY           = 4,
    FALLING_LESSER_RISE     = 5,
    FALLING_GREATER_RISE    = 6,
    RISING_GREATER_RISE     = 7,
    RISING_LESSER_RISE      = 8,
    STEADY                  = 9
  };
  
  //  Counting the array's dimension according to max size
  static const int DEFAULT_SIZE = 2048;
  static const int ARRAY_SIZE = DEFAULT_SIZE/sizeof(Data);
    
  // data members
  Data m_measures[ARRAY_SIZE];
  
  int m_measurments;
  
  Logger m_logger;
};