#include "MeasurementHistory.h"
#include <stdio.h>


MeasurementHistory::MeasurementHistory(Logger logger):
    m_measurments(0),
    m_logger(logger) {
}
  
void MeasurementHistory::addMeasurement(uint32_t pressure, int16_t temp, uint16_t humidity, uint32_t time){
    
    //  Storage of values with the right type
    m_measures[m_measurments%ARRAY_SIZE].pressure = pressure;
    m_measures[m_measurments%ARRAY_SIZE].temp = temp;
    m_measures[m_measurments%ARRAY_SIZE].humidity = humidity;
    m_measures[m_measurments%ARRAY_SIZE].time = time;

    //  Going to the next index
    m_measurments++;
}

int MeasurementHistory::getPressureTrend( uint32_t newPressure) {
    uint8_t m_pressureTrend = 0;
    uint32_t total = 0;
    
    int maxIndex = 0;
    //calculate the index of the array
    if (m_measurments < ARRAY_SIZE) {
        maxIndex = m_measurments;
    } else {
        maxIndex = ARRAY_SIZE;
    }
    //add the value of eache pressure to get the total number of the pressure added
    int i = 0;
    for(; i < maxIndex; i++) {
        total += m_measures[i].pressure;
    }
    //divide the total pressure by the number of the pressure
    uint32_t average = total / i;
    
    m_logger.log("Average Trend:    %u\r\n", average);
    

    //  the newpressure is compared to the average -> finding enum for pressure trend
    if (newPressure == average) m_pressureTrend = STEADY;
    if (newPressure > average)  m_pressureTrend = RISING_CONTINUOUSLY;
    if (newPressure < average)  m_pressureTrend = FALLING_CONTINUOUSLY;
    //  return the value of what the trend is doing
    return m_pressureTrend;
}