#include "Logger.h"


Logger::Logger(bool logTimestamp) :
  m_logTimestamp(logTimestamp) {
}

void Logger::log(const char* format, ...) {
  va_list paramList;
  va_start(paramList, format);
  
  if(m_logTimestamp) {
      // receiving and printing system's time
      printf("[%7u]  ", (uint16_t) time(NULL));
  }
  
  vprintf(format, paramList);
}
