#pragma once

#include "ble/BLE.h"
// for logging
#include "Logger.h"
#include "ReadNotifyGattCharacteristic.h"

class EnvironmentalService {
public:

  typedef uint32_t  PressureType_t;
  typedef int16_t   TemperatureType_t;
  typedef uint16_t  HumidityType_t;
  typedef uint8_t   PressureTrendType_t;
  
  /**
   * @brief   BatteryService constructor.
   * @param   ble Reference to BLE device.
   */
  EnvironmentalService(BLE& ble, Logger& logger);
  
  /**
   * Called after initialization of the BLE module for adding the service
   * to the GATT server
   */
  void addServiceToGattServer(void);
   
  /**
   * @brief   Update pressure level characteristic.
   * @param   newPressure New pressure level measurement.
   */  
  void updatePressureLevel(PressureType_t newPressure);
  
  /**
   * @brief   Update temperature level characteristic.
   * @param   newTemperature New temperature level measurement.
   */  
  void updateTemperatureLevel(TemperatureType_t newTemperature);
  
  /**
   * @brief   Update humidity level characteristic.
   * @param   newHumidity New humidity level measurement.
   */  
  void updateHumidityLevel(HumidityType_t newHumidity);
  
  /**
   * @brief   Update pressure trend characteristic.
   * @param   newPressureTrend New pressure trend measurement.
   */  
  void updatePressureTrend(uint8_t pressureTrend);

private:
  // data members
  BLE& m_ble;
  bool m_serviceAdded;

  PressureType_t        m_pressure;
  TemperatureType_t     m_temperature;
  HumidityType_t        m_humidity;
  PressureTrendType_t   m_pressureTrend;
  
  // characteristics belonging to the service
  ReadNotifyGattCharacteristic<PressureType_t> m_pressureCharacteristic;
  ReadNotifyGattCharacteristic<TemperatureType_t> m_temperatureCharacteristic;
  ReadNotifyGattCharacteristic<HumidityType_t> m_humidityCharacteristic;
  ReadNotifyGattCharacteristic<PressureTrendType_t> m_pressureTrendCharacteristic;
    
  // logger instance
  Logger& m_logger;
};
