#include "EnvironmentalService.h"

#include "mbed.h"

#include <stdio.h>

EnvironmentalService::EnvironmentalService(BLE& ble, Logger& logger)
: m_ble(ble),
  m_serviceAdded(false),
  m_pressureCharacteristic(GattCharacteristic::UUID_PRESSURE_CHAR, &m_pressure),
  m_temperatureCharacteristic(GattCharacteristic::UUID_TEMPERATURE_CHAR, &m_temperature),
  m_humidityCharacteristic(GattCharacteristic::UUID_HUMIDITY_CHAR, &m_humidity),
  m_pressureTrendCharacteristic(0x2AA3, &m_pressureTrend),
  m_logger(logger) {
}

void EnvironmentalService::addServiceToGattServer(void) {
  // We should only ever need to add the information service once
  if (m_serviceAdded) {
    return;
  }

  GattCharacteristic *charTable[] = {
                                      &m_pressureCharacteristic,
                                      &m_temperatureCharacteristic,
                                      &m_humidityCharacteristic,
                                      &m_pressureTrendCharacteristic
                                     };
                                      
  GattService environmentalService(GattService::UUID_ENVIRONMENTAL_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
  m_ble.gattServer().addService(environmentalService);
  
  m_serviceAdded = true;
  
  m_logger.log("Environmental service added\r\n");
}

void EnvironmentalService::updatePressureLevel(PressureType_t newPressure) {
  m_pressure = newPressure;
    
  m_ble.gattServer().write(m_pressureCharacteristic.getValueHandle(), (uint8_t *) &m_pressure, sizeof(PressureType_t));
}

void EnvironmentalService::updateTemperatureLevel(TemperatureType_t newTemperature) {
  m_temperature = newTemperature;
    
  m_ble.gattServer().write(m_temperatureCharacteristic.getValueHandle(), (uint8_t *) &m_temperature, sizeof(m_temperature));
}

void EnvironmentalService::updateHumidityLevel(HumidityType_t newHumidity) {
  m_humidity = newHumidity;
    
  m_ble.gattServer().write(m_humidityCharacteristic.getValueHandle(), (uint8_t *) &m_humidity, sizeof(m_humidity));
}
 //update the value of the pressure's trend
void EnvironmentalService::updatePressureTrend(uint8_t pressureTrend) {
   m_pressureTrend= pressureTrend;

  m_ble.gattServer().write(m_pressureTrendCharacteristic.getValueHandle(), (uint8_t *) &m_pressureTrend, sizeof(m_pressureTrend));
}