#include "mbed.h"
#include "BH1750.h"


DigitalOut myled(LED1);
BH1750 myGY30(D14,D15);
Serial pc(SERIAL_TX, SERIAL_RX);

int main() {
    myGY30.init();
    if(myGY30.getStatus()==0){
        pc.printf("GY-30 initialized...\r\n");
        while(1) {
            myled = !myled;
            pc.printf("%8.5f\r\n",myGY30.readIntesity());
            wait(0.2); // 200 ms
        }
    }else{
        myGY30.init();
    }
}
