#ifndef __ROBOT__H
#define __ROBOT__H
#include "CMPS03.h"
#include "Serializer.h"
#include "PID.h"
#include "SRF05.h"
#include "Servo.h"


#define MAX_ROBOT_SPEED 51
#define PID_RATE 0.05
#define SERVO_RATE .1



class Robot {
public:
    Robot();
    ~Robot();
    int SetDediredHeading(int deg);
    int GetDesiredHeading();
    int GetActualHeading();

    void SetSpeed(int spd);
    void SetSpeed(int lSpd, int rSpd);
    void SetLeftSpeed(int spd);
    void SetRightSpeed(int spd);
    void Stop();
    void ClearCount();
    float GetDistance();
    int GetCount();
    
    void PivetLeft(int deg);
    void PivetRight(int deg);
    void Pivet(int deg);
    void DiGo(int inches,int inPsec);

    float GetRange(int position);



//protected:

//private:
    volatile int desiredHeading;
    volatile int actualHeading;
    volatile int deltaHeading;
    volatile int prevDeltaHeading;
    volatile int desiredSpeed;
    volatile int servoPosition;// [0,10]
    volatile int servoDirection;
    volatile int isFullScan;

    volatile float range0;
    volatile float range1;
    volatile float range2;
    volatile float range3;
    volatile float range4;
    volatile float range5;
    volatile float range6;
    volatile float range7;
    volatile float range8;
    volatile float range9;
    volatile float range10;

    void        TickTick();
    void        TackTack();
    void        FlashLEDs();

    DigitalOut  *led1;
    DigitalOut  *led2;
    DigitalOut  *led3;
    PID         *pid;
    Ticker      ticker1;
    Ticker      ticker2;
    Ticker      ticker3;

    Serializer  base;
    CMPS03      *compass;
//    SRF05       *sensor;
    Servo       *servo;

    float       *range;
    float       *returnRange;
    int         readingNumber;

};
#endif