#ifndef VECTOR_H
#define VECTOR_H

#include "mbed.h"

struct Point
{
    Point() {x=0; y=0;}
    Point(int x, int y) : x(x), y(y) {}
    int x;
    int y;
};

class Vector
{
public:
    Vector(int x0, int y0, int x1, int y1);
    Vector(Point p0, Point p1);
    Vector();
    void orienteVersLeHaut(); // fct qui met la pointe du Vector (p1) vers le haut (dans une console (y inversés donc)) 
    float getCoeffDir() const;
    int getNorme() const;
    bool estADroiteDe(Vector& v) const;
    Vector testJoinedTo(Vector& v) const; // Test si les deux sont joints par un point ; si oui il retourne le nouveau vecteur (AB + BC + AC), si non il retourne le vecteur suivant : Vector(0, 0, 0, 0)
    int calcDifference(Vector& v1, Vector& v2) const;
    Point projection() const;
    static Vector getVectorAuMilieuDe(Vector& v0, Vector& v1);
    
    bool operator==(const Vector& v);
    bool operator!=(const Vector& v);
    
    static Vector v1_ideal;
    static Vector v2_ideal;
    
    //void affVector(Serial& serial) const;
    
private:
    Point p0, p1;
};


#endif // VECTOR_H

