#include "Vector.h"
#include "math.h"

Vector Vector::v1_ideal = Vector(0, 41, 17, 0);
Vector Vector::v2_ideal = Vector(0, 40, 62, 0);

Vector::Vector(int x0, int y0, int x1, int y1)
{
    this->p0.x = x0;
    this->p0.y = y0;
    this->p1.x = x1;
    this->p1.y = y1;
}

Vector::Vector(Point p0, Point p1)
{
    this->p0 = p0;
    this->p1 = p1;
}

Vector::Vector()
{
    this->p0.x = 0;
    this->p0.y = 0;
    this->p1.x = 0;
    this->p1.y = 0;
}

void Vector::orienteVersLeHaut()
{
    if(this->p1.y > this->p0.y)
    {
        Point savep0 = this->p0;
        this->p0 = this->p1;
        this->p1 = savep0;
    }
}

float Vector::getCoeffDir() const
{
    return (float)(this->p0.y - this->p1.y) / (float)(this->p1.x - this->p0.x); // y inversés pcq console tsais
}

int Vector::getNorme() const
{
    return sqrt(pow((float)(this->p1.x - this->p0.x), 2) + pow((float)(this->p1.y - this->p0.y), 2));
}

bool Vector::estADroiteDe(Vector& v) const
{
    if(this->p1.x > v.p1.x)
        return true;
    return false;
}

Vector Vector::testJoinedTo(Vector& v) const
{
    if(this->p0.x == v.p0.x && this->p0.y == v.p0.y)
        return Vector(this->p1.x, this->p1.y, v.p1.x, v.p1.y);
    if(this->p1.x == v.p1.x && this->p1.y == v.p1.y)
        return Vector(this->p0.x, this->p0.y, v.p0.x, v.p0.y);
    if(this->p1.x == v.p0.x && this->p1.y == v.p0.y)
        return Vector(this->p0.x, this->p0.y, v.p1.x, v.p1.y);
    if(this->p0.x == v.p1.x && this->p0.y == v.p1.y)
        return Vector(v.p0.x, v.p0.y, this->p1.x, this->p1.y);
        
    return Vector(0, 0, 0, 0);
}

int Vector::calcDifference(Vector& v1, Vector& v2) const
{
    int diff1, diff2;
    
    diff1 = abs(v1.p0.x - this->p0.x) + abs(v1.p0.y - this->p0.y) + abs(v1.p1.x - this->p1.x) + abs(v1.p1.y - this->p1.y);
    diff2 = abs(v2.p0.x - this->p0.x) + abs(v2.p0.y - this->p0.y) + abs(v2.p1.x - this->p1.x) + abs(v2.p1.y - this->p1.y);
    
    if(diff1 < diff2)
        return 1000 + diff1;
        
    return 2000 + diff2;
}

Point Vector::projection() const
{
    float coeffDir = this->getCoeffDir();
    
    if(coeffDir > 0)
    {
        int y = this->p1.y - (78 - this->p1.x) * coeffDir; // 78 = valx max
        
        if(y >= 0)
            return Point(78, y);
            
        int x = this->p1.x + this->p1.y / coeffDir;
        
        return Point(x, 0);
    }
    else
    {
        int y = this->p1.y + this->p1.x * coeffDir; // 78 = valx max
        
        if(y >= 0)
            return Point(0, y);
            
        int x = this->p1.x + this->p1.y / coeffDir;
        
        return Point(x, 0);
    }
}

Vector Vector::getVectorAuMilieuDe(Vector& v0, Vector& v1)
{
    static Vector vM;
    
    vM.p0.x = (v0.p0.x + v1.p0.x) / 2;
    vM.p0.y = (v0.p0.y + v1.p0.y) / 2;
    vM.p1.x = (v0.p1.x + v1.p1.x) / 2;
    vM.p1.y = (v0.p1.y + v1.p1.y) / 2;
    
    vM.orienteVersLeHaut();
    
    return vM;
}

bool Vector::operator==(const Vector& v)
{
    return (this->p0.x == v.p0.x && this->p0.y == v.p0.y && this->p1.x == v.p1.x && this->p1.y == v.p1.y);
}

bool Vector::operator!=(const Vector& v)
{
    return !(*this == v);
}
/*
void Vector::affVector(Serial& serial) const
{
    serial.printf("x0 : %d, y0 : %d, x1 : %d, y1 : %d\n\r", this->p0.x, this->p0.y, this->p1.x, this->p1.y);
}*/

