#include "mbed.h"

// LED1 = P1.18  LED2 = P1.20  LED3 = P1.21  LED4 = P1.23

#define SPEED 0.125

#define LED_MASK 0x00B40000
#define LED1 0x00040000
#define LED2 0x00100000
#define LED3 0x00200000
#define LED4 0x00800000
void setled(char);


int ledarray[]={LED1,LED2,LED3,LED4};

PortOut ledport(Port1, LED_MASK);

int main() {
    char a=1;
    
    while(1)
    {
        while (a<8) 
        {
            setled(a);
            wait(SPEED);
            setled(0);
            a<<=1;
        }
        while (a>1) 
        {
            setled(a);
            wait(SPEED);
            setled(0);
            a>>=1;
        }
    }
}

void setled(char value)
{
    int mask=0;
   
    for (int i=0;i<4;i++)
    {
        if (value&1)
        {
            mask|=ledarray[i];
        }
        value>>=1;
    }
    ledport=mask;
}    