#ifndef RMD_H
#define RMD_H

#include "mbed.h"

class RMD: public CAN{
    
    public:
        RMD(PinName rx, PinName tx);

        bool send_speed(int id, int speed);
        
        bool send_torque(int id, int torque);
        
        bool send_position(int id, int position, int speed);

        void read_pid();

        void int2byte(int num);
        
        void int2byte2(int pos, int speed);
        
        void status();
        
        int status_velocity();
        
        void status_position();

        char _data[4];

        char _data_sent[8];

        char _data_back[8];

        //void send_speed(int n);

        //unsigned char read_pid();

    private:
        unsigned char CANdata[6];   
        unsigned char CANsent[8];
        CANMessage msg;
        int freq;
        char id;
};

#endif