#include "mbed.h"
#include <stdint.h>
#include "EthernetInterface.h"
#define currentStep 0.01

//CONSTANTS---------------------------------------------------------------------
const int PORT = 7;                             //arbitrary port
static const char* SERVER_IP = "192.168.1.101"; //IP of server board
static const char* MASK = "255.255.255.0";      //mask
static const char* GATEWAY = "192.168.1.1";     //gateway

//STRUCTS-----------------------------------------------------------------------
typedef struct {
 char CtrlType;
 float Out;                                     //output from controller
 float Error;                                   //Error between Iset and Current
 float Iset;                                    //Setpoint value for current
 float Voltage;                                 //Voltage over the H-bridge for thr coil
 float Current;                                 //Current to the H-bridge
}  __attribute__ ((packed)) Setting;

Setting status;
 
//INITS-------------------------------------------------------------------------
SPI spi(PTD2, NC, PTD1);    //mosi, miso(not used), sclk (reset+rdy not used)
DigitalOut cs(PTC12);       //SYNC
DigitalOut led(LED1);
//DigitalOut ledgreen(LED2);

AnalogIn BattVolt(A0);      //ADC for the battery voltage resistordivider = 10k/(36k+10k) = 0.217. Measered voltage = (BattVolt*3.3V)/0.217
AnalogIn CoilVolt(A1);      //ADC for the coil voltage. Measered voltage = (CoilVolt*3.3V)/0.217
AnalogIn Current(A2);       //ADC for the current measurement. Measered current = ((Current/3)-(9/2))/(0.05*N) Number of turns of wire throuth current sensor.

int BattVoltRes, CoilVoltRes, CurrentRes;

PwmOut PwmSpare(D3);        //Extra PWM output
PwmOut PwmAlarm(D5);        //PWM for the alarm output set value = 1 for 100% PWM signal
PwmOut PwmPump(D6);         //PWM output for pump
PwmOut PwmFan(D7);          //PWM output for fan

Serial pc(USBTX, USBRX);    //tx, rx
EthernetInterface eth;      //create ethernet
UDPSocket server;           //creat server
Endpoint client;            //create endpoint
/*
void InitPot(void) {
    cs = 1;                 //Deselect the device
    spi.format(16,1);       //Setup the spi for 16 bit data, SPI mode = 1 
    spi.frequency(1000000); //1MHz clock
    cs = 0;                 //Select the device
    spi.write(0x1803);      //Send 0x1803 to enable updating of RDAC register for changing potentiometer values
    cs = 1;                 //Deselect the device
}

void SetPot(int value) {    //Values from 0-1023 are allowed
    cs = 0;                 //Select the device
    spi.write(0x400+value); //Values from 0x0400 to 0x7FF for digital potentiometer 
    cs = 1;                 //Deselect the device   
}

float GetBattVolt(void) {
    float result; 
    result = (BattVolt.read()*15.207f);
    return result;     
} 

float GetCoilVolt(void) {
    float result; 
    result = (CoilVolt.read()*15.207f);
    return result;     
}

float GetCurrent(void) { //For N=2 turns of wire through sensor
    float result;
    result = (Current.read()*30)-45;
    return result;    
}
*/

void InitEth(void) {
    eth.init(SERVER_IP, MASK, GATEWAY);                                         //set up IP
    eth.connect();                                                              //connect ethernet
    pc.printf("\nSERVER - Server IP Address is %s\r\n", eth.getIPAddress());    //get server IP address;
    server.bind(PORT);                                                          //bind server 
}
    
void ReadSocketDate(void const *args) {
    char buffer[256];
    while(1) {
        int n = server.receiveFrom(client, buffer, sizeof(buffer));  
        memcpy(&status,&buffer[0],sizeof(buffer));
        pc.printf("Out:     %3.3f%\r\n", status.Out);
        pc.printf("Error:   %3.3f%\r\n", status.Error);
        pc.printf("Iset:    %3.3f%\r\n", status.Iset);
        pc.printf("Voltage: %3.3f%\r\n", status.Voltage);
        pc.printf("Current: %3.3f%\r\n", status.Current);      
    }
}

/*
void UpdateCurrent() {
    
    if(HighMoment == true) {
        if(status.Current < status.Iset) {
            CurrentOut =(status.Current + currentStep*(status.Iset-status.Current));
        }
        
        else if(status.Current > status.Iset) {
            CurrentOut = (status.Current - currentStep*(status.Current-status.Iset));
        }    
        
        else {
            CurrentOut = (status.Current);
        }
        pc.printf("CurrentOut: %3.3f%\n\r", CurrentOut);
        //CurrentPot = 0.015*CurrentOut+4; //Conversiom from input current to output voltage to the gate of the MOSFET.
        //CurrentPot = CurrentPot*511.5-1442.45;
        CurrentPot = 7.6725*CurrentOut+603.55;
        pc.printf("CurrentPot: %3.3f%\n\r", CurrentPot);
        SetPot(int(CurrentPot));
    }
}
*/

int main() {

    InitEth();              //setup Ethernet connection
    //InitPot();              //setup potentiometer
    led = 1;
    
    Thread DbThread(ReadSocketDate, NULL, osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25));
        
    while(1) {
    
        led = !led;    
        
        //UpdateCurrent(CurrentOut, CurrentPot);
 
        wait(1);
          
        /*
        for(int i=0; i<1023;i++) {
            SetPot(i);
            wait_us(100);
        }
        pc.printf("BatteryPercent: %3.3f%%\n\r", BattVolt.read()*100.0f);
        pc.printf("CoilPercent: %3.3f%%\n\r", CoilVolt.read()*100.0f);
        pc.printf("CurrentPercent: %3.3f%%\n\r", Current.read()*100.0f);
        
        PwmSpare = 0.1f;
        PwmAlarm = 0.25f;
        PwmPump = 0.5f;
        PwmFan = 0.75f;
        */
    }
}
