#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"

#include "oauth.h"

EthernetNetIf eth(IpAddr(192,168,0,100), //IP Address
                  IpAddr(255,255,255,0), //Network Mask
                  IpAddr(192,168,0,1), //Gateway
                  IpAddr(192,168,0,1)  //DNS
);
NTPClient ntp;
HTTPClient http;

DigitalOut led(LED1);

// IMPORTANT: please change the following keys for your application.

static char const consumer_key[] = "AAAAAAAAAAAAAAAAAAAAAA";
static char const consumer_secret[] = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";

static char const token_key[] = "00000000-AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
static char const token_secret[] = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";

// get current time and set to system clock

void reset_time()
{
    Host server(IpAddr(), 123, "ntp.jst.mfeed.ad.jp");
    ntp.setTime(server);
}

// post message to Twitter

void tweet(char const *message)
{

    std::string uri = "http://api.twitter.com/1/statuses/update.xml";
    uri += "?status=";
    uri += oauth_url_escape(message);

    std::string req_url;
    std::string postarg;

    req_url = oauth_sign_url2(uri.c_str(), &postarg, OA_HMAC, 0, consumer_key, consumer_secret, token_key, token_secret);
    oauth_http_post(req_url.c_str(), postarg.c_str());
}

//

int main()
{
    eth.setup();

    reset_time();

    tweet("Hello, world");

    while(1) {
        led = 1;
        wait(0.5);
        led = 0;
        wait(0.5);
    }
}
