#include "mbed.h"
#include "Servo.h"  // Servo
#include "dPrell.h" // entprelltes Interrupt von Schmiedi

Servo servo_radius(p26);
Servo servo_phi(p25);
dPrell btn (p20);
dPrell btn_start(P1_16);  // Zum hochzählen umd das case zu ändern
DigitalOut laser(p21);
Serial pc(USBTX, USBRX);
double _posr; //für auslesen Position aktueller Radius (-90,-80,...,80,90)
double _posphi;    //für auslesen Position aktueller Winkel Phi(-90,-70,...,70,90)

void readthebutton();    //auslesen Position
void zahlen();  // ISR zum hochzählen zum case ändern
void straightoben(); //Radius von -90 bis 0)
void straightunten(); //Radius von 90 bis 0)
void muster();   // abgefahrenes Muster
int zahler = 0; // zähler zum hochzählen und case ändern


int main()
{
     pc.baud(9600);
    btn.rise(&readthebutton);
    btn_start.rise(&zahlen);
    bool f=false;
    while(1) {

        switch(zahler) {
            case 0:
                if(!f)
                {
                     pc.printf("xCase 0\n");
                    pc.printf("xRichten Sie ihr linkes Auge auf das Kreuz.\nRoten Knopf fuer Start druecken.\n Pressen sie den schwarzen Knopf, sobald Sie den Laser sehen.");
                    f=true;
                }
                break;

            case 1: // linkes Auge
                if(f)
                {
                pc.printf("xCase 1\n");
                muster();
                pc.printf("xRichten Sie ihr rechtes Auge auf das Kreuz. Roten Knopf fuer Start druecken.\n");
                f=false;
                }
                break;

            case 2: //rechtes Auge
                pc.printf("xCase 2\n");
                muster();
                pc.printf("xFertig.\n");
                zahler = 0;
                break;

        }
    }
}
void readthebutton()     //auslesen Position
{
    int x = (_posr * cos(_posphi * 3.1415/180) + 100);
    int y = 100-(_posr * sin(_posphi * 3.1415/180)) + 100;
    pc.printf("%d %d\n", x, y);
}

void zahlen()
{
    zahler++;
    wait(1);
}

void straightoben()   //Radius von -90 bis 0)
{
    for (int i = -90; i <= 0; i+=10) {
        servo_radius.position(i);
        _posr = -i; // fürs umrechnen (Radius ist somit immer zwischen 0 und 90
        laser = 1;
        readthebutton();
        wait(1);
        laser = 0;
        wait(1);

    }
}

void straightunten()   //Radius von 90 bis 0)
{
    for (int i = 90; i >=0; i-=10) {
        servo_radius.position(i);
        _posr = i;
        laser = 1;
        readthebutton();
         wait(1);
        laser = 0;
        wait(1);

    }
}

void muster()    // abgefahrenes Muster
{
    for(int i = -90; i< 90; i+= 15) { //Winkel
        servo_phi.position(i);
        //_posphi = i;
        _posphi = 360-(i + 90);   // für Berechnung, die Winkel gehen nun von 0 bis 180
        //straightoben();
        straightunten();

    }

    for(int i = -90; i< 90; i+= 15) { //Winkel
        servo_phi.position(i);
        //_posphi = i;
        _posphi = 360-(i + 270); // für Berechnung, die Winkel gehen nun von 180 bis 360
        //straightunten();
        straightoben();

    }
}