#include "mbed.h"
#include "Servo.h"  // Servo


//Schrittmotor
DigitalOut enable(p24); // um den Schrittmotor ein- und ausschalten zu können
DigitalOut step(p23); // ist dieser Pin HIGH, macht der Schrittmotor einen Schritt
DigitalOut dir(p22);  // zum Ändern der Drehrichtung des Schrittmotors
Timer t;



//Servo
Servo servo_radius(p26);    //Servomotor zum Ändern des Radius
Servo servo_phi(p25);   //Servomotor zum Ändern des WInkel phi
int _posr; //für das Speichern und Übergeben des aktuellen Radius
int _posphi; //für das Speichern und Übergeben des aktuellen Winkels phi

//Buttons
InterruptIn btn (p20);  //schwarzer??? Button; zum Weiterschalten der States
InterruptIn btn_gross(p19);  // zum Richtungswechsel des Schrittmotors im ST_KINN
                             // wird gedrückt, wenn der Laserpunkt gesehen wird

//Laser
DigitalOut laser(p21);

//Serielle
Serial pc(USBTX, USBRX);    // zur Übertragung der Daten an den Computer über eine Serielle Schnittstelle

//Funktionen
void onestep(); //Schrittmotor bewegt sich um eine, mit der Hardware festgelegten, Schrittweite
void changedir();   //Richtungsänderung des Schrittmotors
void position();    //Position umrechnen und übertragen
void rad_neg(); //Radius von -90 bis 0 abfahren
void rad_pos(); //Radius von 90 bis 0 abfahren
void muster();   // das ganze Muster, dass abgefahren wird
void Init();
void ButtonInterrupt();
void ButtonGehalten();
void ButtonDoppeldrueck();   



//Statemachine
int state;
void funk_nichts();
void funk_kinn();
void funk_links();
void funk_rechts();

const int ST_NICHTS = 1;
const int ST_KINN = 2;
const int ST_LINKS = 3;
const int ST_RECHTS = 4;

int main(void) {
    Init();
    while(1) {
       if(state == ST_NICHTS)
        funk_nichts();
        if(state== ST_KINN)
        funk_kinn();
        if(state == ST_LINKS)
        funk_links();
        if(state == ST_RECHTS)
        funk_rechts();
       
    }
}

void Init()
{
    state = 1;
}

void funk_nichts()
{
     pc.printf("xHalten Sie ihre Augen auf der Hoehe des schwarzen Kreuzes.\n ");
     pc.printf("xST_NICHTS");
     while(1)
    {
        if(btn == 1) 
        {
            state= ST_KINN; 
            return;
        }
    }
}

void funk_kinn()
{
    pc.printf("xHalten Sie den Knopf so lange gedrueckt bis die gewuenschte Hoehe erreicht ist.\n");
    pc.printf("xUm die Richtung zu aendern druecken Sie den Knopf doppelt.\n");
    
    dir = 0;
    btn_gross.rise(&ButtonInterrupt);
    t.start();
    while(1)
    {
        if(btn == 1)
        {
            state = ST_LINKS;
            return;
        }
    }
}

void funk_links()
{
     pc.printf("xLinkes Auge \n ");
     pc.printf("xST_LINKS");
    btn_gross.rise(&position);
    muster();
     while(1)
    {
        if(btn == 1) 
        {
            state= ST_RECHTS; 
            return;
        }
    }
}

void funk_rechts()
{
     pc.printf("xRechtes Auge \n ");
     pc.printf("xST_RECHTS");
    btn_gross.rise(&position);
    muster();
     while(1)
    {
        if(btn == 1) 
        {
            state= ST_NICHTS; 
            return;
    }
}
}
void position()     //auslesen Position
{
    int x = (_posr * cos((double)_posphi * 3.1415/180) + 100);
    int y = 100-(_posr * sin((double)_posphi * 3.1415/180)) + 100;
    pc.printf("%d %d\n", x, y);
}

void rad_neg()   //Radius von -90 bis 0)
{
    for (int i = -90; i <= 0; i+=10) {
        servo_radius.position(i);
        _posr = -i; // fürs umrechnen (Radius ist somit immer zwischen 0 und 90
        laser = 1;
        wait(1);
        laser = 0;
        wait(1);

    }
}

void rad_pos()   //Radius von 90 bis 0)
{
    for (int i = 90; i >=0; i-=10) {
        servo_radius.position(i);
        _posr = i;
        laser = 1;
         wait(1);
        laser = 0;
        wait(1);

    }
}

void muster()    // abgefahrenes Muster
{
    for(int i = -90; i< 90; i+= 15) { //Winkel
        servo_phi.position(i);
        //_posphi = i;
        _posphi = 360-(i + 90);   // für Berechnung, die Winkel gehen nun von 0 bis 180
        //straightoben();
        rad_pos();

    }

    for(int i = -90; i< 90; i+= 15) { //Winkel
        servo_phi.position(i);
        //_posphi = i;
        _posphi = 360-(i + 270); // für Berechnung, die Winkel gehen nun von 180 bis 360
        //straightunten();
        rad_neg();

    }
}

void ButtonInterrupt()
{
    t.reset();
    
    while(btn_gross)
    {
        if(t.read_ms() >= 1000)
        {
            ButtonGehalten();
            return;
        }
    }
    
    while(t.read_ms() <= 1000)
    {
        if(btn_gross)
            ButtonDoppeldrueck();   
    }
}

void ButtonGehalten()
{
    while(btn_gross)
    {
        step = 1;
        wait_ms(10);
        step = 0;
        wait_ms(10);
    }  
}

void ButtonDoppeldrueck()
{
    dir = !dir;
}