#include "robot.h"
#include "mbed.h"
#include "servo.h"

servo::servo(PinName pin):s(pin){
    period = 20;
    dutycycle = 0;
    s.period_ms(period);
}

void servo::toPosition(int angle){
        setPosition(angle);
        s = dutycycle;
}

void servo::toStartPosition(){
        setPosition(0);
        s = dutycycle;
}

void servo::setPosition(int targetAngle){
    float hightime = (targetAngle+180)/180.0;//hightime in ms
    dutycycle = hightime/period;
}