/*
*   File:       lowPlan.h
*   Author:     Shawn Swatek
*   Originated: Spring 2013
*   Revised:    3/29/13
*/

#ifndef __ROBOT__
#define __ROBOT__

#include "mbed.h"
#include "dbgprint.h"
#include "gyroReader.h"
#include "remoteEnc.h"
#include "remoteMotor.h"
#include "absMotors.h"
#include "hcsr04.h"
#include "servo.h"
#include "droidBT.h"
#include "absMotorControl.h"

class robot{
private:
    Timer stepTimer;
    int cameraMode;
public:
    SPI spi;
    remoteEnc bigenc;
    gyroReader gyro;
    //remoteMotor right;
    //remoteMotor left;
    absMotors motors;
    hcsr04 pingLeft;
    hcsr04 pingRight;
    droidBT BTLink;
    absMotorControl cont;
    servo wristServo;
    servo thumbServo;
    servo stickServo;
    servo cameraServo;
    int servoPos;
    int incServo();
    int decServo();
    robot();
    double x,y,rot;
    int circleX,circleY,rectX,rectY,rectRot,triX,triY,triRot;
    int flameLocation;
    int absDriveForward(double angle, int dist);
    int smoothMove(int distance, int rotate, int maxSpeed);
    int driveForward(double angle, int dist);
    void addforward(double dist);
    double turn(double power, double degrees);
    int moveTo(double xInches, double yInches);
    int turntowards(double xInches, double yInches);
    int switchCameraMode(int mode);
    int shapeCheck();
    int pollForShapes();
    int rigCheck();
    int pollForRigs();
    int nearRigCheck();
    int alignWithRig();
    int grabPosition();
    int grab();
    int retractCamera();
    int farCamera();
    int nearCamera();
    int downCamera();
    int extendStick();
    int retractStick();
};

#endif
