#include "remoteMotor.h"
#include "dbgprint.h"

//set everything up
remoteMotor::remoteMotor(remoteEnc &remoteIn, int APin,int BPin, PinName PWMPin) :
        remote(remoteIn), OutPWM(PWMPin){
        
    remoteA=APin;
    remoteB=BPin;
    
    //use a fast pwm signal, because we update it fast, and a slower pwm will lose signals
    OutPWM.period_us(100);
    
    brake();
    reversed=0;
}

//brakes both motors
int remoteMotor::brake(){
    remote.setPin(remoteA,0);
    remote.setPin(remoteB,0);
    OutPWM=1;
    return 1;
}

int remoteMotor::setPower( double power) {
    if((power>=0)^reversed){
        remote.setPin(remoteA,1);
        remote.setPin(remoteB,0);
    } else {
        remote.setPin(remoteA,0);
        remote.setPin(remoteB,1);
    }
    OutPWM=abs(power);
    return 1;
}

int remoteMotor::setReversed(int state){
    if(state!=0){
        reversed=1;
    } else {
        reversed=0;
    }
    return 1;
}


simpleRemoteMotor::simpleRemoteMotor(remoteEnc &remotedev, int remotepinin, PinName PWMPin) :
        remote(remotedev), OutPWM(PWMPin){
        
    DBGPRINT("bbbhal",1);
    remotepin=remotepinin;
    setPower(0);
    reversed=0;
}

int simpleRemoteMotor::setPower( double power) {
    if((power>=0)^reversed){
        remote.setPin(remotepin,1);
    } else {
        remote.setPin(remotepin,0);
    }
    OutPWM=abs(power);
    currPower=power;
    return 1;
}

int simpleRemoteMotor::setReversed(int state){
    if(state!=0){
        reversed=1;
    } else {
        reversed=0;
    }
    return 1;
}