/*
*   File:       remoteEnc.h
*   Author:     Shawn Swatek
*   Originated: Spring 2013
*   Revised:    3/28/13
*/

#ifndef __REMOTEENC__
#define __REMOTEENC__

#include "mbed.h"


//this class handles the atmega that collects encoder ticks
// it's connected via an SPI bus 
// it also has 6 digital out pins that can be set using commands as well
// all commands are 1-length and recieve one bit responses, so for example the low and high bits of an encoder are separate requests
class remoteEnc{
private:
    SPI &spi; //uses a reference to the spi bus so that it can also be used elsewhere
    DigitalOut cs; //chip select, needs to be brought low to communicate with the device
    int referenceCounts[4]; //the base number of counts that are compared against
    int latestCount[4]; 
    int latestActual[4];
    int latestQuadrant[4]; //quadrants are used to deal with overflow, more in the .cpp file, getVals() function
    int direction[4];
    int outState;
public:
    remoteEnc(SPI &spiIn, PinName cspin);
    //this probably has a memory leak
    const int* getVals();
    const int* getReferences() {return referenceCounts;}
    int setDirections(int dir1, int dir2, int dir3, int dir4);
    int getSingleValue(int slot);
    int setPins(int mask);
    int setPin(int pin, int state);
    int getPinState();
    int reset(int slot);
    int resetAll();
    int getLastVal(int slot);
};

#endif