#include "droidBT.h"
#include "nodbgprint.h"

droidBT::droidBT(PinName tx, PinName rx) : droid(tx,rx){
    BTStart=0;
    BTEnd=0;
    DCStart=0;
    DCEnd=0;
    droid.baud(115200);
    droid.attach(this,&droidBT::BTEnqueue);
}

void droidBT::BTEnqueue(){
    //while(droid.readable()){
        //led1=1;
        BTBuffer[BTEnd]=droid.getc();
        //int a = LPC_UART1->RBR;
        //led2=1;
        //commits
        // fffffffffuuuuuuuu
        //int b = LPC_UART2->RBR;
        //led3=1;
        //with
        //int c = LPC_UART3->RBR;
        //messing
        // hello world
        // hi
        //led4=1;
        //DBGPRINT("Got %x\n", BTBuffer[BTEnd]);
        BTEnd++;
        BTEnd%=BTBUFSIZE;
        //led1=0;
    //}
}

int droidBT::clearData(){
    DCStart=DCEnd=0;
    return 1;
}

int droidBT::getData(int cmd, int* dest){
    procBuf(1);
    int i;
    for(i=DCStart;i!=DCEnd;i=(i+1)%DCHUNKSIZE){
        if((DataChunk[i][0]&0xF0)==0x60 && DataChunk[i][1]==cmd){
            DataChunk[i][0]=0;
            if(i==DCStart){
                DCStart++;
            }
            for(int j=0;j<17;j++){
                dest[j]=DataChunk[i][j];
                DataChunk[i][j]=0;
            }
            return 1;
        }
    }
    return 0;
}

int droidBT::procBuf(int cmd){
    int i=BTStart;
    int startChunk=i;
    //int seen=0;
    int cheapHash=0;
    while (i!=BTEnd) {
        if(i==startChunk){ //first bit in the chunk
            if((BTBuffer[i]&0xF0)==0x60){//data returned
                cheapHash=BTBuffer[i];
                DBGPRINT("gettin data\r\n",1);
                i++;
            } else if((BTBuffer[i]&0xF0)==0xF0){//ack
                cheapHash=BTBuffer[i];
                DBGPRINT("gettin ack %x\r\n",BTBuffer[i]);
                BTBuffer[i]=0xF1;
                i++;
            } else {//dunno what this data is, toss
                //BTStart++;
                DBGPRINT("throwing away %x\r\n",BTBuffer[i]);
                i++;
                startChunk=i;
                BTStart = i;
            }
        } else {
            DBGPRINT("not first\r\n",1);
            if(bufSize()>=(BTBuffer[startChunk]&0xF)+1){
                DBGPRINT("got enough space %x, %d\r\n",BTBuffer[startChunk]&0xF, DCEnd);
                DataChunk[DCEnd][0]=BTBuffer[startChunk];
                int j;
                for(j=0;j<(BTBuffer[startChunk]&0xF);j++){
                    DBGPRINT("copying %d, %d\r\n",BTBuffer[i+j], j);
                    DataChunk[DCEnd][j+1]=BTBuffer[i+j];
                    if(j<((BTBuffer[startChunk]&0xF)-1)){
                        cheapHash^=BTBuffer[i+j];
                    }
                }
                //check and store if the hash matched
                if(cheapHash == BTBuffer[i+(BTBuffer[startChunk]&0xF)-1]){
                    DBGPRINT("Hash Matches\r\n",1);
                    DataChunk[DCEnd][(BTBuffer[startChunk]&0xF)]=1;
                    if(DCEnd>=DCHUNKSIZE)
                        DCEnd=0;
                    DCEnd++;
                }else{
                    DBGPRINT("Hash Does Not Match\r\n",1);
                    DataChunk[DCEnd][(BTBuffer[startChunk]&0xF)]=0;
                }
                DBGPRINT("Got Data of size %d [%x %d %d]\n", BTBuffer[startChunk]&0xF, DataChunk[DCEnd-1][1], DataChunk[DCEnd-1][2], DataChunk[DCEnd-1][3]);
                
                BTStart=i+j;
                startChunk=i=BTStart;
            } else {
                break;
            }
        }
                
    }
    return 0;
}
int droidBT::bufSize(){
    return (BTEnd+BTBUFSIZE-BTStart)%BTBUFSIZE;
}

//returns both bits in an int form to look for
int droidBT::setState(char State) {
    int sendbuf[10];
    sendbuf[0]=0xF3;
    sendbuf[1]=State;
    sendbuf[2]=0x11;
    sendbuf[3]=0x44;
    int i, cheapHash=0;
    droid.putc(sendbuf[0]);
    for(i=1;i<4;i++){
        droid.putc(sendbuf[i]);
        cheapHash^=sendbuf[i];
    }
    return 0xF300|(cheapHash&0xFF);
}

int droidBT::sendCmd(int cmd, int* info, int len) {
    //int sendbuf[10];
    //sendbuf[0]=(0xF0|(len+1));
    //sendbuf[1]=cmd;
    //sendbuf[2]=0x11;
    //sendbuf[3]=0x44;
    int i, cheapHash=cmd;
    droid.putc((0xF0|(len+1)));
    droid.putc(cmd);
    for(i=0;i<len;i++){
        droid.putc(info[i]);
        cheapHash^=info[i];
    }
    return 0xF000|((len+1)<<8)|(cheapHash&0xFF);
}

int droidBT::getAck(int hashetc){
    int firstbit=(hashetc&0xFF00)>>8;
    int secondbit=hashetc&0xFF;
    int i;
    if(BTStart==BTEnd) return 0;
    for(i=BTStart;i!=BTEnd-1;i=(i+1)%BTBUFSIZE){
        if(BTBuffer[i]==firstbit && BTBuffer[i+1]==secondbit){
            BTBuffer[i]=BTBuffer[i+1]=0;
            if(i==BTStart)
                BTStart+=2;
            return 1;
        }
    }
    return 0;
}