/*
*   File:       absMotors.h
*   Author:     Shawn Swatek
*   Originated: Spring 2014
*   Revised:    2/3/14
*/

#ifndef __ABSMOTORS__
#define __ABSMOTORS__

#include "mbed.h"
#include "dbgprint.h"

//each motor is driven by three control wires, one for the high side of the motor, one for the low side, and a pwm (digital approximation of analog) for speed
// the two non-pwm signals come from the remote processor and are controlled by this class

class absMotors{
private:
    SPI &spi;
    DigitalOut cs;
    int setA;
    int setB;
public:
    absMotors(SPI &spiIn, DigitalOut cspin);
    int moveForward(int counts);
    int moveWheels(int deltaA, int deltaB);
    int setDest(int newA, int newB);
    int getSetPoint(int &Apass, int &Bpass);
    int setSetPoint(int Anew, int Bnew);
};

#endif