#include "absMotors.h"
#include "dbgprint.h"

absMotors::absMotors(SPI &spiIn, DigitalOut cspin): spi(spiIn), cs(cspin){
    cs=1;
    spi.format(8,0);
    spi.frequency(1000000);
    setA=32768;
    setB=32768;
}
int absMotors::moveForward(int counts){
    setA-=counts;
    setB-=counts;
    setDest(setA,setB);
    return 0;
}
int absMotors::moveWheels(int deltaA, int deltaB){
    setA-=deltaA;
    setB-=deltaB;
    setDest(setA,setB);
    return 0;
}
int absMotors::setDest(int newA, int newB){
    uint8_t a[5];
    int i;
    newB = -newB;
    a[0]=0x80|(newB>>9);
    a[1]=0x80|((newB&0x01FF)>>2);
    a[2]=0x80|((newB&0x0003)<<5)|(newA>>11);
    a[3]=0x80|((newA&0x07FF)>>4);
    a[4]=0x40|(newA&0x0F);
    cs = 0;
    for(i=0;i<5;i++)
        spi.write(a[i]);
    spi.write(0);
    int out=spi.write(0);
    cs = 1;
    //DBGPRINT("Result of Setting Point: %d\r\n",out);
    return out;
}
int absMotors::getSetPoint(int &Apass, int &Bpass){
    Apass = setA;
    Bpass = setB;
    return 0;
}
int absMotors::setSetPoint(int Anew, int Bnew){
    setA = Anew;
    setB = Bnew;
    return 0;
}