#ifndef __ABSMOTORCONTROL_H__
#define __ABSMOTORCONTROL_H__

#include "mbed.h"
#include "dbgprint.h"
#include "absMotors.h"

class absMotorControl{
private:
    absMotors &motors;
    int leftSpeed;
    int rightSpeed;
    int maxLeftSpeed;
    int maxRightSpeed;
    int leftDest;
    int rightDest;
    int leftTicks;
    int rightTicks;
    int leftFalloffDist;
    int rightFalloffDist;
    int updateCount;
    char limited;
    Ticker motorKeeper;
    void updateMotors();
    int slowMode;
public:
    absMotorControl(absMotors &motorsIn);
    //direct setting of speed, dangerous
    void setSpeed(int left, int right);
    //ramps each motor separately to given destinations
    void setDest(int left, int right);
    //ramps each motor to a set speed
    void rampSpeed(int left,int right);
    //sets max speed for each motor
    void setMaxSpeed(int newLeftMax, int newRightMax);
    // start and stop the ticker that runs this controller
    void start();
    void stop();
    //returns true if the robot has stopped moving, so it's safe to stop the controller
    int stopped();
    //returns true when the speeds are equal to the maximums
    int steady();
    //reset the counters on distance traveled
    void resetTicks();
    int avgTicks();
    void setSlowMode(int factor);
};

#endif
