/*
*   File:       remoteMotor.h
*   Author:     Shawn Swatek
*   Originated: Spring 2013
*   Revised:    3/30/13
*/

#ifndef __REMOTEMOTOR__
#define __REMOTEMOTOR__

#include "mbed.h"
#include "remoteEnc.h"

//each motor is driven by three control wires, one for the high side of the motor, one for the low side, and a pwm (digital approximation of analog) for speed
// the two non-pwm signals come from the remote processor and are controlled by this class

class remoteMotor {
private:
    remoteEnc &remote;
    int remoteA;
    int remoteB;
    PwmOut OutPWM;
    int reversed;
public:
    remoteMotor(remoteEnc &remoteIn, int APin,int BPin, PinName PWMPin);
    int setPower(double power);
    int setReversed(int state);
    int brake();
};

// this is for a different style of motor driver that only uses one wire for forward/reverse, and another for pwm-ing enable
class simpleRemoteMotor {
private:
    remoteEnc &remote;
    int remotepin;
    PwmOut OutPWM;
    int reversed;
    double currPower;
public:
    simpleRemoteMotor(remoteEnc &remotedev, int remotepinin, PinName PWMPin);
    int setPower(double power);
    int setReversed(int state);
    double getPower() {return currPower;}
};

#endif