/*
*   File:       gyroReader.h
*   Author:     Shawn Swatek
*   Originated: Spring 2013
*   Revised:    3/29/13
*/

#ifndef __GYROREADER__
#define __GYROREADER__

#include "mbed.h"
#include "dbgprint.h"


// This class deals with all the things to do with the gyro, accelerometer, and magnetometer package
// currently only the gyro is useful, and it's the only sensor being constantly polled.
class gyroReader{
private:
    I2C accel;
    int gyroZcount;
    int gyroXcount;
    int zcal;
    int xcal;
    int polls;
    Ticker gyroUpkeepTicker;
    
    
    int startAccel();
    
    float checkAccel();
    
    int checkGyro(int& xacc, int& yacc, int& zacc);

public:

    int xmag,ymag,zmag;
    double xoffs,zoffs,xamp,zamp;
    double compDir;
    float checkCompass();
    
    void gyroUpkeep();
    gyroReader(PinName pinA, PinName pinB);
    
    void setLevel();
    void resetZ();
    int getZ();
    double getZDegrees();
    int getX();
    int getPolls(){ return polls;}
    int compZ(int compVal);
    void reset();
    void calibrate();
    void start();
    void stop();
};

#endif