/*
*   File:       droidBT.h
*   Author:     Shawn Swatek
*   Originated: Spring 2013
*   Revised:    3/29/13
*/

#ifndef __DROIDBT__
#define __DROIDBT__

#include "mbed.h"

#define BTBUFSIZE 1000
#define DCHUNKSIZE 100

class droidBT{
private:
    volatile int BTBuffer[BTBUFSIZE];
    volatile int BTStart;
    volatile int BTEnd;
    volatile int DataChunk[DCHUNKSIZE][17];
    volatile int DCStart;
    volatile int DCEnd;
    Serial droid;
    void BTEnqueue();
public:
    int clearData();
    int getData(int cmd, int* dest);
    int sendCmd(int cmd, int* info, int len);
    int procBuf(int cmd);
    droidBT(PinName tx, PinName rx);
    int bufSize();
    int setState(char state);
    int getAck(int hashetc);
    
};

#endif
