#include "absMotorControl.h"

#define STEPSPERINC 2

absMotorControl::absMotorControl(absMotors &motorsIn): motors(motorsIn){
    leftSpeed=rightSpeed=0;
    maxLeftSpeed=0;
    maxRightSpeed=0;
    motors.getSetPoint(leftDest,rightDest);
    leftFalloffDist=0;
    rightFalloffDist=0;
    updateCount=0;
    resetTicks();
    limited=0;
    slowMode = 1;
    //start();
}

void absMotorControl::updateMotors(){
    int leftDistToFalloff;
    leftFalloffDist = (leftSpeed*(leftSpeed-1)*STEPSPERINC)/2;
    if(leftSpeed>0){
        leftDistToFalloff = leftDest - leftTicks - leftFalloffDist;
    } else {
        leftDistToFalloff =  leftTicks - leftFalloffDist - leftDest;
    }
    int rightDistToFalloff;
    rightFalloffDist = (rightSpeed*(rightSpeed-1)*STEPSPERINC)/2;
    if(rightSpeed>0){
        rightDistToFalloff = rightDest - rightTicks - rightFalloffDist;
    } else {
        rightDistToFalloff =  rightTicks - rightFalloffDist - rightDest;
    }
        
    if(limited){
        if(leftDistToFalloff < leftSpeed){
            if(leftDistToFalloff > 0){
            } else {
            }
        }
    }
    if(updateCount%STEPSPERINC==0){
        //move speeds closer to their max value
        if(leftSpeed<maxLeftSpeed)
            leftSpeed++;
        else if(leftSpeed>maxLeftSpeed)
            leftSpeed--;
        if(rightSpeed<maxRightSpeed)
            rightSpeed++;
        else if(rightSpeed>maxRightSpeed)
            rightSpeed--;
    }
    /*if(i==startFall-1){
        //calibration step before we start falling to get an exact result
        move = distance-totalMove-distToMax;
    }
    if(i>=startFall && (i-startFall)%stepsPerInc==0){
        if(i==startFall) //reset move after calibration step
            move=maxSpeed;
        
        //decrement every stepsPerInc steps until stopped
        move--;
    }
    totalMove+=move;*/
    if(updateCount%slowMode==0){
        motors.moveWheels(leftSpeed,rightSpeed);
        leftTicks+=leftSpeed;
        rightTicks+=rightSpeed;
    }
    updateCount++;
}
void absMotorControl::setSpeed(int left, int right){
    leftSpeed = maxLeftSpeed = left;
    rightSpeed = maxRightSpeed = right;
}
void absMotorControl::rampSpeed(int left,int right){
    maxLeftSpeed = left;
    maxRightSpeed = right;
}
void absMotorControl::start(){
    motorKeeper.attach_us(this,&absMotorControl::updateMotors,10000);
}
void absMotorControl::stop(){
    motorKeeper.detach();
}
int absMotorControl::stopped(){
    if(leftSpeed == 0 && rightSpeed == 0)
        return 1;
    return 0;
}

int absMotorControl::steady(){
    if(leftSpeed == maxLeftSpeed && rightSpeed == maxRightSpeed)
        return 1;
    return 0;
}
void absMotorControl::resetTicks(){
    leftTicks = rightTicks = 0;
}
int absMotorControl::avgTicks(){
    return (leftTicks+rightTicks)/2;
}
void absMotorControl::setSlowMode(int factor){
    slowMode = factor;
}