//******************************************************************************
//   filter.h
//
//   Description: Header file of filter module
//
//   Author: Jason shen
//   Version    1.00
//   DDC BJ
//   October 2011
//   Built with IAR Embedded Workbench Version: 5.30A
//******************************************************************************
//Change Log:
//******************************************************************************
//Version:  1.00
//Comments: Initial Release Version
//******************************************************************************

#ifndef FILTER_H
#define FILTER_H
#include "mbed.h"


struct filter_args_s {
    float v[3];         //data buffer, record the 3 datas in queue
    float K_ini;        //ini value of K
    float K_curr;       //current value of K
    float K_inc;        //increment value of K
    float K_max;        //max value of K
    float threshold;    //
    char  dir_flag;     //p_dir or n_dir
    char  dir_cnt;      //counts or p_dir or n_dir
};

class Filter
{
public:
    //int32_t first_order_filter(int32_t old_data, int32_t new_data, int32_t K, int32_t threshold);
    float first_order_filter(float old_data, float new_data, float K, float threshold);
    int32_t first_order_filter_adaptive_K(int32_t old_data, int32_t new_data, int32_t threshold, int32_t K_increment, int32_t K_max);
    float first_order_filter_adaptive_K(float new_data, filter_args_s *arg);
    int16_t SignalFilter(int16_t data, int16_t _filter, int16_t _order);
    void max_min(uint16_t data[], uint16_t n, uint16_t *max, uint16_t *min);
    void sum_avg(uint16_t data[], uint16_t n, uint32_t *sum, float *avg);
    void stdev(uint16_t data[], uint16_t n, float *s);
};


#endif
