#ifndef CALCULATE_H
#define CALCULATE_H

#include "cal_const.h"

//Rt(ohm) = 1 /( (Vcc - Vamb2)/(Rs*Vamb2) - 1/Rp)
//TC = 1/(Ka + Kb*ln(r)+Kc*(ln(r)^3))-273.15
#define Rt_Ka   (0.00088608989f)
#define Rt_Kb   (0.00025170399f)
#define Rt_Kc   (0.00000019152616f)
#define Rt(N_Rt)   ((N_Rt) * 7870.0 / (65535.0 - (N_Rt)))
#define ToC_Rt(Rt)  (1.0 / (Rt_Ka + log(Rt)* Rt_Kb + log(Rt)*log(Rt)*log(Rt)* Rt_Kc) - 273.15)

// Macro of temperature unit conversion
#define CTOF(c) ((c)*1.8+32.0)
#define CTOS(c) (((c)+40.0)*9.0)
#define CTOK(c) ((c)+273.15)

#define FTOC(f) (((f)-32.0)/1.8)
#define FTOS(f) (((f)+40.0)*5.0)
#define FTOK(f) (((f)-32.0)/1.8+273.15)

#define STOC(s) ((s)/9.0-40.0)
#define STOF(s) ((s)/5.0-40.0)
#define STOK(s) ((s)/9.0+233.15)

#define KTOC(k) ((k)-273.15)
#define KTOF(k) (((k)-273.15)*1.8+32.0)
#define KTOS(k) (((k)-233.15)*9.0)

class Calculate
{
public:
    float linterp(const float* _x, const float* _y, float val, unsigned char size);
    void calcu_Tir_oS(float * targTempS, float PSdOut, float ambTempC, const struct CalibrationConstants CalConst, float emissivity);
    float get_Tamb_oC(float N_Tamb);
};

#endif // calculate.h