// cal_const.h
// Header file of cal_const.c


// Version history
// Version   Date       Author     Remarks
// --------------------------------------------------------------------------------------------------------------------------------
// 1.0       14-09-25   Jason Shen   Initial


#ifndef CAL_CONST_H
#define CAL_CONST_H

#include "calculate.h"

#define CALI_CONST_IR_TAB_NUM       35  // Number of table for IR
#define TEMP_CO_NUM                 2
#define GAIN_OFS_NUM                2

struct CalibrationConstants  // Store the calibration constants
{
    float Td0;                                  // Detector temperature when calibrating 25oC
    float Ofs;                                  // Offset for 1M table
    float En        [CALI_CONST_IR_TAB_NUM];    // Table of energy of target 1M
    float ToS       [CALI_CONST_IR_TAB_NUM];    // Table of temperature, IR
    float TempCo    [TEMP_CO_NUM];              // Detector responsibility temp coefficient
    float GainOfs   [GAIN_OFS_NUM];             // amp channel gain and offset
    float TempSHi;                              // Temperature range high limit in S (0.1S)              
    float TempSLo;                              // Temperature range low limit in S (0.1S)  
};

extern const struct CalibrationConstants CalConst_1M, CalConst_2M;

#endif
