// CalConst.c
// Calibration constants management
// Real calibration values gotten from Charley on 2005-11-25.
// OSC, PSBatTh, TempSLow, TempSHigh, PSd1_T1Max, PSd2_T2Max use theoratical cal constants not real calibration value.

// Version history
// Version   Date       Author     Remarks
// --------------------------------------------------------------------------------------------------------------------------------
// 1.0       07-01-25   Frank Lu   Original version for Codfish
// 1.20      09-03-27   Kaiyuan Lv Add Gain and Offset into count

#include "cal_const.h"



#define amp_gain (222.0)
#define Vofs_ir  (3.0*10/(75000+10))
#define Nofs_ir  (Vofs_ir*amp_gain*65535.0/3.0)

#define USE_CALIBRATION_CONSTANTS   20140925


const struct CalibrationConstants CalConst_1M = {

#if  USE_CALIBRATION_CONSTANTS == 0 //Default calibration constants
    // Td0 oC
    25.0,
    // Ofs
    -1212.0,
    // En[]
    {31364,45150,64897,93134,133437,190850,272476,388286,552245,783857,1110290,1569282,2213097,3113909,4371084,6121002,8550263,11913371,16556330,23188312,32059315,44200899,60770031,83314411,113897978,155264800,211052702,286071377,386664326,521180134,700587203,939278150,1256127582,1675892699,2231085089},
    // ToS[]
    {65790,67945,70194,72544,75000,77570,80260,83078,86033,89135,92394,95820,99427,103229,107239,111475,115955,120699,125732,131078,136766,142829,149303,156231,163661,171647,180253,189552,199631,210591,222551,235656,250077,266023,283752},
    // TempCo
    {0.0, -25.0},
    // GainOfs
    {149.1055, 505.652},  
    // TempSHi
    273600.0,
    // TempSLo
    66600.0,
#elif USE_CALIBRATION_CONSTANTS == 20140925
// calibration constants 20140925
    // Td0 oC
    25.0,
    // Ofs
    -1212.0,
    // En[]
    {31364,45150,64897,93134,133437,190850,272476,388286,552245,783857,1110290,1569282,2213097,3113909,4371084,6121002,8550263,11913371,16556330,23188312,32059315,44200899,60770031,83314411,113897978,155264800,211052702,286071377,386664326,521180134,700587203,939278150,1256127582,1675892699,2231085089},
    // ToS[]
    {65790,67945,70194,72544,75000,77570,80260,83078,86033,89135,92394,95820,99427,103229,107239,111475,115955,120699,125732,131078,136766,142829,149303,156231,163661,171647,180253,189552,199631,210591,222551,235656,250077,266023,283752},
    // TempCo
    {0.0, -25.0},
    // GainOfs
    {149.1055, 505.652},  
    // TempSHi
    273600.0,
    // TempSLo
    66600.0,   

#else
#error USE_CALIBRATION_CONSTANTS invalid!
#endif

};

const struct CalibrationConstants CalConst_2M = {

#if  USE_CALIBRATION_CONSTANTS == 0 //Default calibration constants
    // Td0 oC
    25.0,
    // Ofs
    -11859.0,
    // En[]
    {79224,107010,144522,195140,263399,355386,479252,645900,869889,1170636,1573989,2114296,2837124,3802810,5091091,6807144,9089421,12119813,16136797,21452414,28474157,37733151,49920395,65933368,86935938,114435468,150382217,197297851,258442289,338031569,441524477,576003290,750685602,977622450,1272667230},
    // ToS[]
    {39060,40443,41890,43405,44994,46660,48409,50247,52180,54215,56360,58623,61014,63542,66219,69058,72073,75280,78698,82346,86248,90430,94922,99760,104983,110638,116782,123479,130806,138856,147743,157604,168609,180970,194959},
    // TempCo
    {16.0, -64.0},
    // GainOfs
    {69.7778, 467.953},  
    // TempSHi
    183600.0,
    // TempSLo
    39600.0,
#elif USE_CALIBRATION_CONSTANTS == 20140925
// calibration constants 20140925
    // Td0 oC
    25.0,
    // Ofs
    -11859.0,
    // En[]
    {79224,107010,144522,195140,263399,355386,479252,645900,869889,1170636,1573989,2114296,2837124,3802810,5091091,6807144,9089421,12119813,16136797,21452414,28474157,37733151,49920395,65933368,86935938,114435468,150382217,197297851,258442289,338031569,441524477,576003290,750685602,977622450,1272667230},
    // ToS[]
    {39060,40443,41890,43405,44994,46660,48409,50247,52180,54215,56360,58623,61014,63542,66219,69058,72073,75280,78698,82346,86248,90430,94922,99760,104983,110638,116782,123479,130806,138856,147743,157604,168609,180970,194959},
    // TempCo
    {16.0, -64.0},
    // GainOfs
    {69.7778, 467.953},  
    // TempSHi
    183600.0,
    // TempSLo
    39600.0,
    

#else
#error USE_CALIBRATION_CONSTANTS invalid!
#endif

};



