/* 
RPC - リモートプロシージャコール
RPC (Remote Procedure Call)とは、プログラムから別のアドレス空間（別のCPUだったり、ネットワーク越しのPCだったり）にあるプログラムを実行する技術。 

mbedのRPCコマンドの形式は次のとおりです。
/<Object Name>/<Method Name>

"/" だけ送ると、使用できるObject Nameを返します。

"/<Object Name>" だけ送ると、使用できるMethod Nameを返します。

RPC Over HTTP

ウェブブラウザからも RPC を使用して、 mbed のハードウェアをコントロールすることができます。
グローバルIPアドレス（WAN）で使う場合はセキュリティ機能（認証など）を載せたほうがいいでしょう。
Information

HTTP経由のRPCコマンドの形式は http://<url of mbed>/rpc/<Object name>/<Method name> <Arguments separated by spaces>

svr.addHandler<RPCHandler>("/rpc"); 

Sample

http://192.168.0.123/rpc/DigitalIn/new p5 myport
    これはmbedのプログラムで
    DigitalIn myport(p5);
    を実行したのと同じです。
    成功すると myport と返ってきます。
 
http://192.168.0.123/rpc/myport/read
    これはmbedのプログラムで
    myport.read();
    を実行したのと同じです。
    ポートの状態 0 または 1 が返ってきます。

※ 192.168.0.123 はユーザーの環境に合わせてください。

また、上のプログラムは mbed のUSBストレージ（USBメモリ）にもアクセスできますので RPCを使ったhtmlファイルを入れておくといいでしょう。
Sample

http://192.168.0.123/files/mbed.htm

webブラウザから
http://192.168.0.123/rpc/led3/write 1
とするとLED3 が点灯することを確認する。

http://192.168.0.123/rpc/led3/write 0
とするとLED3 が消灯する。

*/

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "MSCFileSystem.h"

#define FSNAME "msc"
MSCFileSystem msc(FSNAME);

//EthernetNetIf eth;

EthernetNetIf eth(
  IpAddr(172,16,3,150), //IP Address 172.16.3.130 to 172.16.3.150
  IpAddr(255,255,0,0), //Network Mask
//  IpAddr(172,16,0,254), //Gateway
//  IpAddr(172,168,3,10)  //DNS
  IpAddr(172,16,3,150), //Gateway
  IpAddr(172,16,3,150)  //DNS
);

HTTPServer svr;

Serial pc(USBTX,USBRX);

DigitalOut led1(LED1,"led1");
DigitalOut led2(LED2,"led2");
DigitalOut led3(LED3,"led3");
DigitalOut led4(LED4,"led4");

int main() {

    DIR *d;
    struct dirent *p;

    pc.printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        pc.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    pc.printf("Setup OK\n");

    FSHandler::mount("/" FSNAME "/web", "/web"); //Mount /usb path on web root path
    d = opendir("/" FSNAME "/web");
    
    pc.printf("\nList of files on the flash drive:\n");
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )
        {
            pc.printf(" - %s\n", p->d_name);
        }
    }
    else
    {
        pc.printf("Could not open directory!");
        error("Could not open directory!");
    }


  
    Base::add_rpc_class<DigitalOut>();
    //svr.addHandler<SimpleHandler>("/"); //Default handler
    svr.addHandler<FSHandler>("/web"); //Default handler
    //svr.addHandler<FSHandler>("/"); //Default handler
    svr.addHandler<RPCHandler>("/rpc");
    svr.bind(80);
    printf("Listening... n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while(true)
    {
        Net::poll();
    }
  
  return 0;
}
