#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

EthernetNetIf eth;  
HTTPServer svr;

Serial pc(USBTX,USBRX);

DigitalOut led1(LED1);

int main() {
  pc.printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    pc.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  pc.printf("Setup OK\n");
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  pc.printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;
}
