#ifndef VIEW_H
#define VIEW_H
#include "mbed.h"
#include "button.h"
#include "horloge.h"
#include "stm32746g_discovery_lcd.h"
#include <list>

#define SCREENWIDTH 480
#define SCREENHEIGHT 272

class View
{
public:
    View(int width = SCREENWIDTH, int height = SCREENHEIGHT, uint32_t bgColor = LCD_COLOR_WHITE);
    void contain(int x, int y);
    void drawStatic();
    void drawDynamic();
    void updateHorloge();

private :
    int16_t m_width = SCREENWIDTH;
    int16_t m_height = SCREENHEIGHT;
    uint32_t m_bgColor = LCD_COLOR_BLACK;
    list <Button> m_buttonList;
    uint8_t m_horlogeX;
    uint8_t m_reveilX;
    Horloge h;
    
};

#endif