#include "view.h"
#include "stm32746g_discovery_lcd.h"
#include "mbed.h"
#include "button.h"
#include <list>

View::View(int width, int height, uint32_t bgColor)
    : m_width(width), m_height(height), m_bgColor(bgColor), m_horlogeX(40), m_reveilX(200)
{
    
    // creation des boutons
    
    // reglage de l'heure
    Button heurePlus(m_horlogeX, 110, 35, 30);
    Button heureMoins(m_horlogeX + 60 ,110 , 35, 30);
    Button minutePlus(m_horlogeX, 190, 35, 30);
    Button minuteMoins(m_horlogeX + 60 ,190 , 35, 30);
    
    heurePlus.setText("+" );
    heureMoins.setText("-");
    minutePlus.setText("+");
    minuteMoins.setText("-");
    
    m_buttonList.push_back(heurePlus);
    m_buttonList.push_back(heureMoins);
    m_buttonList.push_back(minutePlus);
    m_buttonList.push_back(minuteMoins);
    
    // reglage du reveil
    Button reveilHeurePlus(m_reveilX, 110, 35, 30);
    Button reveilHeureMoins(m_reveilX + 60 ,110 , 35, 30);
    Button reveilMinutePlus(m_reveilX, 190, 35, 30);
    Button reveilMinuteMoins(m_reveilX + 60 ,190 , 35, 30);
    
    reveilHeurePlus.setText("+" );
    reveilHeureMoins.setText("-");
    reveilMinutePlus.setText("+");
    reveilMinuteMoins.setText("-");
    
    m_buttonList.push_back(reveilHeurePlus); // id = 0
    m_buttonList.push_back(reveilHeureMoins); // id = 1
    m_buttonList.push_back(reveilMinutePlus); // id = 2
    m_buttonList.push_back(reveilMinuteMoins); // id = 3
    
    // initialisation
    drawDynamic();
    drawStatic();
    
}


void View::contain(int x, int y)
{
        // s'execute lorsque l'on a touché un point de l'ecran
        // récupère les coordonnées du point, si elles correspondent
        // aux coordonnes d'un bouton, on execute la fonction correspondante
        int idBut = 0;
        for (Button it : m_buttonList) {
            if (it.contain(x,y)) {
                if (idBut == 0) {
                    // bouton heurePlus
                    h.heureP();
                    HAL_Delay(220);
                } else if(idBut == 1) {
                    // bouton heureMoins
                    h.heureM();
                    HAL_Delay(220);
                } else if(idBut == 2) {
                    // bouton MinutePlus
                    h.minuteP();
                    HAL_Delay(100);
                } else if(idBut == 3) {
                    // bouton MinuteMoins
                    h.minuteM();
                    HAL_Delay(100);
                }
                
            }
            idBut++;
        }
}

void View::drawStatic()
{
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    
    // trace le texte
    uint8_t text[30];
    BSP_LCD_SetTextColor(LCD_COLOR_LIGHTGRAY);
    
        // horloge
    sprintf((char*)text, "Horloge");
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(m_horlogeX, 20, (uint8_t *)&text, LEFT_MODE);
    
    sprintf((char*)text, "heures");
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_DisplayStringAt(m_horlogeX, 80, (uint8_t *)&text, LEFT_MODE);
    
    sprintf((char*)text, "minutes");
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_DisplayStringAt(m_horlogeX, 160, (uint8_t *)&text, LEFT_MODE);
    
        // reveil
    sprintf((char*)text, "Reveil");
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(m_reveilX, 20, (uint8_t *)&text, LEFT_MODE);
    
    sprintf((char*)text, "heures");
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_DisplayStringAt(m_reveilX, 80, (uint8_t *)&text, LEFT_MODE);
    
    sprintf((char*)text, "minutes");
    BSP_LCD_SetFont(&Font20);
    BSP_LCD_DisplayStringAt(m_reveilX, 160, (uint8_t *)&text, LEFT_MODE);
    
    // trace les boutons
    BSP_LCD_SetFont(&Font12);
    for (Button it : m_buttonList) {
        it.draw();
    }
    
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
}

void View::drawDynamic() {
    //uint8_t text[30];
    BSP_LCD_SetTextColor(LCD_COLOR_LIGHTGRAY);
    BSP_LCD_SetFont(&Font20);
    
    // trace l'heure
        int minutes = h.getMinutes();
        uint8_t text[5];
        vector<uint8_t> digits;
        digits = h.get4Digits();
        
        sprintf((char*)text, "%d%d:%d%d",  digits.at(0),  digits.at(1),  digits.at(2),  digits.at(3));
        BSP_LCD_DisplayStringAt(m_horlogeX, 50, (uint8_t *)&text, LEFT_MODE);
}

void View::updateHorloge() {
    h.update();
}