#include "mbed.h"
#include "button.h"
#include "horloge.h"
#include "view.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "time.h"
#include <list>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    
//    PwmOut pwmtest(D12);
//    pwmtest.period(0.00002f);
//    pwmtest.write(0.2f);

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    // initialisation de l'écran
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        while (1);
    } else {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    HAL_Delay(100);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetTextColor(LCD_COLOR_LIGHTGRAY);
    
    // initialisation de la vue, l'horloge commence a ce moment là
    View v;

    while(1) {
        v.updateHorloge();
        v.drawDynamic();
        
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            cleared = 0;
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                v.contain(x, y);
            }
        } else {
            if (!cleared) {
                v.drawStatic();
                v.drawDynamic();
                
                cleared = 1;
            }
        }
    }
}