#ifndef HORLOGE_H
#define HORLOGE_H
#include <stdint.h>
#include <vector>
#include "mbed.h"

using namespace std;
//#include "stm32746g_discovery_lcd.h"
class Horloge
{

public:
    Horloge();
    void setTempsPrecedent(uint8_t minutes, uint8_t heures);
    vector<uint8_t> get4Digits();
    uint8_t getMinutes();
    uint8_t getHeures();
    uint8_t getMinutesPre();
    uint8_t getHeuresPre();
    void setRegistres(DigitalOut* dataPin, DigitalOut* clockPin, uint8_t data);
    void minuteP();
    void minuteM();
    void heureP();
    void heureM();
    void update();
    void sonner();
    
private :
//    Serial pc(USBTX, USBRX, 115200)
    DigitalOut* dataPin;
    DigitalOut* clockPin;
    DigitalOut* latchPin;
    PwmOut* enablePin;
    uint8_t m_minutes;
    uint8_t m_heures;
    uint8_t m_minutesPre;
    uint8_t m_heuresPre;
    uint8_t m_secondesPre;
    bool m_reveilActif;
    uint8_t m_minutesReveil;
    uint8_t m_heuresReveil;
    bool point = false;
    
    uint8_t m_table[10] = {
        0b01110111, // 0 ABCDEF
        0b01000001, // 1 BC
        0b00111011, // 2 ABDEG
        0b01101011, // 3 ABCDG
        0b01001101, // 4 BCFG
        0b01101110, // 5 ACDFG
        0b01111110, // 6 ACDEFG
        0b01000011, // 7 ABC
        0b01111111, // 8 ABCDEFG
        0b01101111, // 9 ABCDFG
    };
    uint8_t m_table3[10] = {
        0b01110111, // 0 ABCDEF
        0b01000001, // 1 BC
        0b10110011, // 2 ABDEG
        0b11100011, // 3 ABCDG
        0b11000101, // 4 BCFG
        0b11100110, // 5 ACDFG
        0b11110110, // 6 ACDEFG
        0b01000011, // 7 ABC
        0b11110111, // 8 ABCDEFG
        0b11100111, // 9 ABCDFG
    };
    
};
#endif