#include "horloge.h"
#include "mbed.h"
#include <stdint.h>
#include <vector>
//#include "stm32746g_discovery_lcd.h"


Horloge::Horloge() 
    : m_minutes(59), m_heures(23), m_minutesPre(100), m_heuresPre(100), m_secondesPre(100)
{
    set_time(54);
    dataPin = new DigitalOut(D8, 0);
    clockPin = new DigitalOut(D9, 0);
    latchPin = new DigitalOut(D10, 0);
    enablePin = new PwmOut(D11);
    enablePin->period(0.00002f);
    enablePin->write(0.6f);
    
}

void Horloge::setTempsPrecedent(uint8_t minutes, uint8_t heures) {
    m_minutesPre = minutes;
    m_heuresPre = heures;
}

vector<uint8_t> Horloge::get4Digits() {
    vector<uint8_t> digits;
    
    digits.push_back(m_heures / 10);
    digits.push_back(m_heures % 10);
    digits.push_back(m_minutes / 10);
    digits.push_back(m_minutes % 10);
    
    return digits;   
}

uint8_t Horloge::getMinutes() {
    return m_minutes;
}

uint8_t Horloge::getHeures() {
    return m_heures;
}

uint8_t Horloge::getMinutesPre() {
    return m_minutesPre;
}

uint8_t Horloge::getHeuresPre() {
    return m_heuresPre;
}

void Horloge::setRegistres(DigitalOut* dataPin, DigitalOut* clockPin, uint8_t data) {
    for(uint8_t i = 0; i < 8; i++)
    {
        dataPin->write(data & (1 << i));
        HAL_Delay(1);
        clockPin->write(1);
        HAL_Delay(1);
        clockPin->write(0);
    }
}

void Horloge::minuteP() {
    if(m_minutes == 59) {
        m_minutes = 0;
        heureP();
    } else {
        m_minutes++;
    }
}

void Horloge::minuteM() {
    if(m_minutes == 0) {
        m_minutes = 59;
    } else {
        m_minutes--;
    }
}

void Horloge::heureP() {
    if(m_heures == 23) {
        m_heures = 0;
    } else {
        m_heures++;
    }
}

void Horloge::heureM() {
    if(m_heures == 0) {
        m_heures = 23;
    } else {
        m_heures--;
    }
}

void Horloge::update() {
    // récupère l'heure
    uint8_t secondes = (uint8_t)time(NULL);
    if(secondes == 59) {
        set_time(0);
        minuteP();
        
    }
    // affiche l'heure sur les LEDs si elle a changée
    if (secondes != m_secondesPre) {
        vector<uint8_t> temps = get4Digits();
    
        latchPin->write(1);
        if(point == true) {
            setRegistres(dataPin, clockPin, m_table[temps.at(0)]);
            setRegistres(dataPin, clockPin, m_table[temps.at(1)]+128);
            setRegistres(dataPin, clockPin, m_table3[temps.at(2)]+8);
            setRegistres(dataPin, clockPin, m_table[temps.at(3)]);
        } else {
            setRegistres(dataPin, clockPin, m_table[temps.at(0)]);
            setRegistres(dataPin, clockPin, m_table[temps.at(1)]);
            setRegistres(dataPin, clockPin, m_table3[temps.at(2)]);
            setRegistres(dataPin, clockPin, m_table[temps.at(3)]);
        }
        latchPin->write(0);
        point = !point;
    }
    
    m_secondesPre = secondes;
}

void Horloge::sonner() {
    
}
    