#include "mbed.h"               // mbed: ver 95, rtos: 64
#include "SWUpdate_class.h"           // ver 1
#include "SWUpdate.h"                 // ver 20


// Server url to where the Software will be found.
const char *url = "http://192.168.10.21:8000";

// Base filename for the software (e.g. if you save it as "abcdefg.bin", use "abcdefg" here)
// Remember: some servers are case-sensitive!
const char *name = "SWUP";

extern "C" void mbed_reset();
//extern "C" void Thread::wait();
   
int UpdateFirmware::UpdateCheck(void)
{
    int res;
    //pc.printf("SoftwareUpdateCheck (%s) (%s)\r\n", url, name);
    SWUpdate_T su = SoftwareUpdate(url, name, DEFER_REBOOT);
    if (SWUP_OK == su) {
        //pc.printf("  Update installed, rebooting ...\r\n");
        res = 1;
    } 
    else if (SWUP_SAME_VER == su) {
        res =  0;
        //pc.printf("  no update available.\r\n");
    } 
    else {
        res =  -1;
        //pc.printf("  update failed %04X\r\n", su);
    }
    return res;
}

void UpdateFirmware::rebootMbed(void)
{
    mbed_reset();
}