/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "SPISlave_multiByte.h"

#if DEVICE_SPISLAVE

namespace mbed {

SPISlave_multiByte::SPISlave_multiByte(PinName mosi, PinName miso, PinName sclk, PinName ssel) :
    _spi(),
    _bits(8),
    _mode(0),
    _hz(1000000)
 {
    spi_init_multibyte(&_spi, mosi, miso, sclk, ssel);
    spi_format_multibyte(&_spi, _bits, _mode, 1);
   // spi_frequency_multibyte(&_spi, _hz);
}

void SPISlave_multiByte::format(int bits, int mode) {
    _bits = bits;
    _mode = mode;
    spi_format_multibyte(&_spi, _bits, _mode, 1);
}

void SPISlave_multiByte::frequency(int hz) {
    _hz = hz;
    spi_frequency_multibyte(&_spi, _hz);
}

int SPISlave_multiByte::receive(int bytes) {
    return(spi_slave_receive_multibyte(&_spi, bytes));
}

int SPISlave_multiByte::read(void) {
    return(spi_slave_read_multibyte(&_spi));
}

void SPISlave_multiByte::reply(uint8_t *value, int bytes) {
    spi_slave_write_multibyte(&_spi, value, bytes);
}

bool SPISlave_multiByte::readable(void){
     return get_spi_slave_readable(&_spi);
    }

} // namespace mbed

#endif