/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_DOOR_SERVICE_H__
#define __BLE_DOOR_SERVICE_H__

class DOORService {
public:
    const static uint16_t DOOR_SERVICE_UUID              = 0xA000;
    const static uint16_t DOOR_STATE_CHARACTERISTIC_UUID = 0xA001 ;

    DOORService(BLEDevice &_ble, uint8_t initialValueForDOORCharacteristic): 
        ble(_ble), doorState(DOOR_STATE_CHARACTERISTIC_UUID, &initialValueForDOORCharacteristic)
    {
        GattCharacteristic *charTable[] = {&doorState};
        GattService         doorCTL_Service(DOOR_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(doorCTL_Service);
    }

    GattAttribute::Handle_t getValueHandle() const {
        return doorState.getValueHandle();
    }

private:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<uint8_t>  doorState;
};

#endif /* #ifndef __BLE_LED_SERVICE_H__ */
