#ifndef AS7000_H
#define AS7000_H

#include "mbed.h"
#define AS7000Address 0x60
//Register definitions
#define AS7000_STARTUP  0x04 //4
#define HR_ONLY         0x08 //8
#define HR_ONLY_LEN     0x07 //7
#define HR_REG          0x12 //18
#define HR_LEN          21

typedef struct{
  uint8_t  transaction_id;
  uint8_t  status;
  uint8_t  hreat_rate;
  uint8_t  signal_QA;
  uint16_t LED_current;
  uint8_t  SYNC;
  uint8_t  startup_flag;
  bool     contact_detected;
}as7000_t;




/** Class for operating AMS AS7000 sensor over I2C **/
class AS7000 
{ 
public: 

/** Create AS7000 instance **/
    AS7000(PinName SDA, PinName SCL); 
    
    void gpio_init(void);
    void enable   (void);///< Heart Rate Sensor Enbable API,it include startup senario
    void startup  (void);
    void hr_only  (void);///< Hreat Rate Sensor sensing and data
    void update (void);
    as7000_t hrm;  

    
    private:    
        I2C _i2c;
        char rx,tx[2],address;
        char rawdata[22];
        char hreat_rate;
        char startup_flag;
        
void readchar(char location){
    tx[0] = location;
    _i2c.write(address,tx,1,true);
    _i2c.read(address,&rx,1,false);
}

void writechar(char location, char value){
    tx[0] = location;
    tx[1] = value;
    _i2c.write(address,tx,2);
}
    };
#endif