#include "AS7000.h"
#include "mbed.h"

DigitalOut AS7000_GPIO8(p5); //NNN50-P5 map to GPIO-8 for AS7000 on/off
DigitalInOut AS7000_INT(p4); //NNN50-P4 GPIO-5 for AS7000 INT


AS7000::AS7000(PinName SDA, PinName SCL) : _i2c(SDA,SCL){
    //Set I2C fast and bring reset line high
    _i2c.frequency(400000);
    address = AS7000Address;
    
    AS7000_INT.mode(PullNone);
    
    AS7000_INT.output();
     
    AS7000_GPIO8.write(1); // Power OFF AS7000
    AS7000_INT.write(1); // AS7000 GPIO OUTPUT LOW
    AS7000_INT.input();
    wait_ms(100);
}
    
void AS7000::enable(void){
        char cmd[2];
        
        AS7000_GPIO8.write(0); //Power ON AS7000
        wait_ms(280);    //Wait for > 250ms for booting
          
        cmd[0] = AS7000_STARTUP; //0x04;       
        cmd[1] = 0x02;
        _i2c.write(address, cmd, 2);
         wait_ms(35);  
    
}

void AS7000::update(void){
    hrm.transaction_id = rawdata[0];
    hrm.status         = rawdata[1];
    hrm.hreat_rate     = rawdata[2];
    hrm.signal_QA      = rawdata[3];
    hrm.LED_current    = ((rawdata[4]<<8)+rawdata[5]);
    hrm.SYNC           = rawdata[6];    
}

void AS7000::hr_only(void){
    char cmd[2];
     cmd[0] = HR_ONLY;
     if(AS7000_INT == 0) {
        _i2c.write(address, cmd, 1);
        _i2c.read(address, rawdata, 7, false);
        wait_ms(10);
        update();
    }      
}
