//MQTT i mbed biblioteke
#include "mb_pins.h"
#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
//Biblioteke za OLED
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"
//Opste biblioteke
#include <string.h>
//I2C makroi
#define I2C_ADDRESS         0x3c
#define I2C_ADD_MBED    I2C_ADDRESS << 1
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128

#define WAIT_MS 10

TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
WiFiInterface *wifi;
 
I2C i2c_obj(MB_OLED_SDA, MB_OLED_SCL);
Adafruit_SSD1306_I2c oled(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);
AnalogIn pot1(MB_POT1);

char* topic_sub = "pubpim";
char* topic_pub = "subpim";
const char* hostname = "broker.hivemq.com";
int port = 1883;

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Browser message: %.*s \n", message.payloadlen, (char*)message.payload);
    
    oled.clearDisplay();
    oled.setTextCursor(0, 0);
    oled.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    oled.display();
    oled.clearDisplay();
    oled.display();
}
 
void pot1Mess(MQTT::MessageData& md){
    char buf(100);
    printf(buf, "V(POT1) = %1.2f \r\n", pot1*(3.3f));
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void *)buf;
    message.payloadlen = strlen(buf) + 1;
    client.publish(topic_pub, message);
}

void oledPrint(MQTT::MessageData& md){
    oled.clearDisplay();
    oled.setTextCursor(0, 0);
    oled.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    oled.display();   
}

int main(){
    wifi = WiFiInterface::get_default_instance();
    
    printf("Connecting to %s... \n",MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if(ret != 0){
        printf("Greska u povezivanju");
        return -1;
    }
    printf("Success!\n");
    
    socket.open(wifi);
    socket.connect(hostname,port);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-12";
 
    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);
    
    while(true) {
        thread_sleep_for(WAIT_MS);
        client.yield(1000);
    }
    
    char* startMess = "start";
    char* stopMess = "stop";
    char* oledMess = "oled";
    
    while(!strcmp((char*)message.payload, startMess)){
        client.subscribe(topic_sub, MQTT::QOS0, pot1Mess());
        if(!strcmp((char*)message.payload, stopMess)){
               break;
        }
    }
    
    if(!strcmp((char*)message.payload, oledMess)){
        oled.begin();
        i2c_obj.frequency(400000);
        client.subscribe(topic_sub, MQTT::QOS0, oledPrint);
    }
    
    
    
}